<?php
require_once "../Connections.php";
require_once "../functions/sortArrays.php";
require_once "../functions/channels.php";

function getCameraHealth($getterVideo, $getterCamStatInfo)
{
   $cameras = [];
   if (isset($getterVideo->video->input)) {
      $arr = [];
      $isExistIpcams = true;
      if (isset($getterVideo->video->ipcams) && $getterVideo->video->ipcams <= $getterVideo->video->inputs) {
         $count = $getterVideo->video->ipcams;
      } else {
         $count = $getterVideo->video->inputs;
         $isExistIpcams = false;
      }
      $arr = $getterVideo->video->input;
      $arr = sort_nested_arrays($arr, ["index" => "desc"]);
      $arr = fillEmptyChannels($arr, $count, $isExistIpcams);

      $arr = array_slice($arr, 0, $count);
      $stat = $getterCamStatInfo->CamStatInfo;
      $stat = array_slice($stat, 0, $count);
      //echo json_encode($stat);
      foreach ($arr as $camera) {
         $json = [];
         $json["index"] = $camera->index;
         $json["enabled"] = isset($camera->enabled) ? $camera->enabled : 0;

         $json["ip"] = isset($camera->ip) ? $camera->ip : "0.0.0.0";
         $json["virgin"] = isset($camera->ip) ? false : true;
         $json["url"] = isset($camera->url) ? true : false;
         $json["url2"] = isset($camera->url2) ? true : false;

         if (isset($camera->title1251)) {
            $json["title"] = $camera->title1251;
         }
         $json["thread1"] = false;
         $json["thread2"] = false;
         array_push($cameras, $json);
      }

      foreach ($stat as $camera) {
         $id = $camera->id;
         if ($camera->fps[0] != 0) {
            $cameras[$id - 1]["thread1"] = true;
            $cameras[$id - 1]["url"] = true;
         }
         if ($camera->fps[1] != 0) {
            $cameras[$id - 1]["thread2"] = true;
            $cameras[$id - 1]["url2"] = true;
         }
      }
   } else {
      $count = isset($getterVideo->video->ipcams) ? $getterVideo->video->ipcams : 0;
      for ($i = 0; $i < $count; $i++) {
         $camera = [];
         $camera["index"] = $i;
         $camera["enabled"] = 0;
         $camera["ip"] = "0.0.0.0";
         $camera["url"] = false;
         $camera["url2"] = false;
         $camera["title"] = "Камера " . ($i + 1);
         $camera["thread1"] = false;
         $camera["thread2"] = false;
         array_push($cameras, $camera);
      }
   }

   return $cameras;
}
